# Aim of script: Figurte 6, elife paper
# Prepared by : Charles Agoti
# Last updated : 29 Jun 2022

rm(list=ls())

library(tidyverse); library(dplyr);library("lubridate");  library(tidytree); library(readxl)
library(treeio); library(artyfarty);library(wesanderson); library(janitor); library(scales);
library(lubridate); library(ggtree);library(writexl); 

## Basic set-up
setwd("~/Dropbox/COVID-19/SECONDWAVE/global/")
color_coast <- c("#FF0000","#000000","#00FFFF",'#FFA500','#0000FF',"#FF00FF")
plot_color <- c("#FF0000", "#FFFF00", "#00EAFF", "#AA00FF", "#FF7F00", "#BFFF00", "#0095FF","#FF00AA","#FFD400", "#6AFF00", "#0040FF","#EDB9B9", "#B9D7ED", 
                "#E7E9B9", "#DCB9ED", "#B9EDE0", "#8F2323", "#23628F", "#8F6A23", "#6B238F", "#4F8F23", "#000000", "#737373", "#CCCCCC")
plot_color2=c("#000000","#C0C0C0","#696969","#FF0000","#F2D2BD",
             "#800000","#C9A9A6","#00FF00","#008000","#00FFFF","#BA6B57", "#FFA500","#9933FF",
             "#A4C639","#0000FF","#CCCCFF","#FF00FF","#55ACEE", "#b1bca0")

metadata_df2 <-read.csv("~/Dropbox/COVID-19/SECONDWAVE/revision/Final/Figures/Figure 8/Source_data_2_global_metadata_26Feb2021.csv")
glimpse(metadata_df2)

#####################################.....................Figure 6...................#####################################################################
## (a) Time tree
recent_sub_1 <-as.Date(metadata_df2%>%filter(subsample==1)%>%select(date)%>%max()%>%date_decimal()%>%format("%Y-%m-%d"))
recent_sub_1

class(recent_sub_1); decimal_date(recent_sub_1)

tree_sub_1 <-read.tree("~/Dropbox/COVID-19/SECONDWAVE/global/all_sequences/subsample1/timetree.nwk")

p_sub_1 <- ggtree(tree_sub_1, mrsd=recent_sub_1,as.Date=TRUE, color='grey40',size=0.2) + 
  theme_tree2()+
  scale_x_date(date_labels = "%B\n%Y",date_breaks = "3 month", minor_breaks = "1 month")+
  expand_limits(y = 11200)+
  theme(axis.text.x = element_text(size = 11,angle=0))
p_sub_1

Figure_6 <-  p_sub_1%<+% metadata_df2+ 
  geom_tippoint(aes(subset=(group=='coastal'),fill=key_lineage, shape=county), color="black", size=3, stroke=0.7)+
  geom_tippoint(aes(subset=(group=='coastal'),color=key_lineage, shape=county), size=3, stroke=0.2)+
  geom_tippoint(aes(subset=(group=='non_Coastal_Kenya')),size=2,stroke=0.2,color='black',shape=20)+
  scale_shape_manual(values = c(21, 22, 23, 24, 25, 8))+
  scale_fill_manual(values = plot_color2, guide="none")+
  scale_color_manual(values = plot_color2)+
  labs(y="Number of sequences", x="")+
  #coord_flip()+
  theme_scientific()+
  geom_vline(xintercept = as.Date("2020-09-16"), size=0.5, linetype="longdash", color="black")+
  geom_text(x=as.Date("2020-06-15"), y=11200, label="Wave 1", size=3)+
  geom_text(x=as.Date("2020-12-15"), y=11200, label="Wave 2", size=3)+
  scale_y_continuous(limits=c(0,11200), minor_breaks = seq(0 , 11200, 500), breaks = seq(0 ,11200, 1000))+
  theme(axis.title.x = element_text(size = 11),
        axis.title.y =  element_text(size = 11),
        axis.text.x = element_text(size = 11),
        axis.text.y= element_text(size = 11),
        #legend.position = c(0.25, 0.8),
        legend.position = "right",
        legend.key.size = unit(0.25, "cm"),
        legend.spacing.x = unit(0.25, 'cm'),
        legend.spacing.y = unit(0.25, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        legend.background = element_rect(fill="#FFFFFF", color = NA),
        legend.box.background = element_blank())+
  guides(shape=guide_legend(ncol=1, title = "County", title.position = "top"),
         colour=guide_legend(ncol=1, title = "Lineage", title.position = "top"), size=T)

pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.6/Fig.6.pdf", width = 8.27, height = 10.03)
print(Figure_6)
dev.off()
Figure_6
